
from flask_babel import gettext as _

definitions = {
    "BMP":_("Convert your images to the BMP format with this free online image converter. You can convert from over 120 source formats."),
    "EPS":_("Create an EPS file by converting your image with this free online image converter. It also allows to optionally select digital filters to enhance the quality of your images."),
    "GIF":_("Free online image converter to convert images to the GIF format. Also supports conversion from video to animated GIFs."),
    "ICO":_("Convert your image to the ICO format with this free online ICO conversion tool. You can also create a favicon.ico with this converter."),
    "JPG":_("Convert your files from over 120 formats to a JPG image with this free online JPEG converter. Optionally apply digital effects."),
    "PNG":_("Convert image from over 120 image formats to PNG with this free online image converter. Optionally add digital effects to enhance the images."),
    "SVG":_("Convert your image to the SVG format with this free online image converter. Additionally add effects to obtain high quality images."),
    "TGA":_("Free online image converter for converting all kinds of images to the TGA (Targa) format. Includes optional effect settings and digital filters."),
    "TIFF":_("Convert your image to TIFF with this free online image converter. You can further apply digital filters to change their look. "),
    "WBMP":_("Convert your image to the WBMP format with this free online image converter. Optionally apply digital effects as needed to alter your image."),
    "WebP":_("This free online WebP converter allows you to convert images to the WebP standard from Google. Just upload a file or provide a URL and your WebP file can be downloaded immediately. "),
    
    "7Z":_("Create 7z compressed archives or convert existing archives to the 7z format with this free online archive generator."),
    "TZ":_("Create 7z compressed archives or convert existing archives to the 7z format with this free online archive generator. "),
    "TAR.BZ2":_("A free online archive generator that lets you compress your file or convert an archive to the TAR.BZ2 format. "),
    "TAR.GZ":_("Create TAR.GZ archives or convert existing archives to TAR.GZ with this fast and free online converter. Just upload your file or provide a URL to start converting. "),
    "ZIP":_("Use this free online tool to create a ZIP archive of your files or convert an archive to ZIP. Provide a URL or upload your file to start the conversion. "),
    
    "AAC":_("Free online AAC converter to convert audio or video to the AAC audio format. Free and fast providing high quality."),
    "AIFF":_("Convert your audio files to AIFF with this free and fast online audio converter. Change settings to further enhance audio conversion."),
    "FLAC":_("Convert your music to the FLAC format with this free online audio converter. Choose additional options to further enhance quality."),
    "M4V":_("Convert your music to the M4V format with this free online audio converter. Also allows to rip audio from video files."),
    "MMF":_("Convert your music to the MMF ringtone format with this free online audio converter. Can also extract audio from video files."),
    "MP3":_("Convert your audio or video files to MP3 audio with this free online MP3 converter. Great quality for music conversion. You can also extract MP3 from video files."),
    "OGG":_("Convert your audio files to the OGG format with this free online OGG converter. By uploading a video file you can also extract the audio track to OGG."),
    "OPUS":_("Convert your files to the new OPUS audio format with this free online audio converter. Choose among several settings to obtain high quality results."),
    "WAV":_("Convert your audio to the WAV format with this free online WAV converter. You can optionally extract audio tracks from video and convert them to WAV. "),
    "WMA":_("Convert your audio to the Microsoft WMA format with this free online WMA converter. Optionally upload video files to strip the audio track from the video track and convert it to WMA. "),
    
    "3G2":_("Convert your video files to the 3G2 format with this free online video converter. Change settings to enhance your 3G2 video. High quality."),
    "3GP":_("Convert your video files to 3GP with this free and fast online converter. Optionally change further settings to enhance your video."),
    "AVI":_("Online media converter to convert your video from over 50 source formats to AVI in high quality. Optional settings can be provided to enhance the quality."),
    "FLV":_("Convert your video to FLV with this free online video converter. Choose optional settings to enhance your video. "),
    "MKV":_("Convert videos to the Matroska MKV format with this free online video converter. Provides high quality and pretty fast."),
    "MOV":_("Convert your videos to Apple Quicktime MOV format with this free online video converter. Provides high quality."),
    "MP4":_("Convert your video to MP4 with this free online video converter. The MP4 video conversion is done in high quality while still providing fast results."),
    "MPG":_("Convert your video files to the MPG standard with this free and online video converter. It offers many options like cutting and selecting the encoding format."),
    "OGV":_("Convert your video to the OGV format with this free online video converter and optionally change quality parameters. Fully compatible with the HTML5 specification. "),
    "WEBM":_("Convert a video to the brand new WEBM format from Google with this free online video converter. Optionally set further options to enhance quality."),
    "WMV":_("Convert your videos to the Microsoft WMV format with this fast and free online converter. Provides optional settings to enhance video material. "),

    "DOC":_("Convert PDF to word with this free online converter. Upload any text document or a pdf file and download instantly your word document."),
    "DOCX":_("Convert your documents to the Microsoft DOCX format with this free online document converter. "),
    "HTML":_("Convert your documents to HTML with this free online HTML converter."),
    "ODT":_("Convert your documents to the Open-Office ODT format with this free online document converter. "),
    "PDF":_("Convert your document or image to PDF with this free online PDF converter. Support for over 250 source formats."),
    "PPT":_("Free online file converter to convert various file types like PPTX or ODP to the Microsoft Powerpoint PPT format."),
    "PPTX":_("Online converter to create Microsoft Powerpoint presentations in the new PPTX format. Free of charge providing high quality file conversion results."),
    "RTF":_("This free online RTF converter allows you to convert your files and ebooks to the RTF format without installing any software on your computer. It even can convert text from images."),
    "TXT":_("This free online media converter lets you convert your documents and ebooks to the TXT format, including OCR. Fast and high quality conversion."),
    "XLSX":_("Convert your file to XLSX with this free online file converter. OCR is supported in case you want to convert from PDF to XLSX. "),

    "AZW3":_("Free online ebook converter to convert your ebooks to the AZW 3 format from Amazon for your Kindle."),
    "EPUB":_("Convert your text for your ebook to the ePub format with this free online ePub converter. Select the target ebook reader for better accuracy. "),
    "FB2":_("Convert text or other ebooks to the FictionBook FB2 format with this free online FB2 converter. Select the target ebook reader for better accuracy."),
    "LIT":_("Create an ebook in the LIT format for Microsoft reader with this free online ebook converter. Specify your target reader to optimize the output."),
    "LRF":_("Convert documents like text, PDF or other ebooks to the Sony LRF format with this free online ebook converter. Specify the target device to get best conversion results. "),
    "MOBI":_("An Online MOBI converter that can convert documents and ebooks to the mobi ebook reader format. Optionally set target reader to further enhance quality. "),
    "PDF":_("Convert text to PDF optimized for ebook readers with this free online ebook converter. Select target devices like the Kindle or Sony reader to enhance formatting."),
    "PDB":_("Convert your text, ebooks or documents to the Palm PDB ebook format in high quality with this free online ebook converter"),
    "TCR":_("This free online ebook converter lets you easily convert ebooks and text files to the TCR format in high quality."),

    "Dailymotion":_("This online video converter helps you to meet the video specifications needed when you want to upload your video to Dailymotion."),
    "Facebook":_("A free online video converter that allows you to convert a video to be uploaded on Facebook. Includes high quality presets."),
    "Instagram":_("A free online converter that allows you to convert your file so it can be uploaded to Instagram. Select quality and size via presets."),
    "Telegram":_("Convert your video file with this online video converter so you can share it inline in Telegram."),
    "Twitch":_("This online video converter converts your file to a file format that is accepted by Twitch for upload."),
    "Twitter":_("This online converter converts your video or image to a format that is accepted for upload by Twitter."),
    "Viber":_("A video converter for Viber that allows you to convert your video to a file format Viber accepts."),
    "Vimeo":_("Preprocess and convert your video files to a format vimeo accepts with this free vimeo video converter. Set the quality and screen size using our high quality presets."),
    "WhatsApp":_("An online file converter to create files that can be easily uploaded to WhatsApp. Choose a high preset for quality and size or cut the video."),
    "Youtube":_("Choose a preset to prepare your files before you upload them to Youtube. Fix file issues if Youtube requires a different format. "),

    "Android":_("Convert your video to the Android format with this free online file converter. Set optional parameters to refine the conversion process."),
    "Blackberry":_("This free online Blackberry video converter lets you convert your video files to the format your Blackberry can play. Online and for free. "),
    "iPad":_("Create videos optimized for Apple iPad devices with this free online iPad converter. Additionally you can change settings to further enhance the video."),
    "iPhone":_("With this free online video converter you can convert your videos to the iPhone format. Upload a file or provide a URL to a video."),
    "iPod":_("This online converter is optimized to convert your video for your iPod. The converter is free and provides fast result."),
    "PlayStation":_("Convert your video to the Playstation PS3 format with this free and fast online converter. High quality."),
    "PSP":_("Free online video converter to convert your video files to a Playstaion Poratble (PSP) format. Upload a file or provide a link to a URL."),
    "Wii":_("Convert video to the Nintendo Wii format, online and free. Just upload your video file or provide a URL and start converting. Wii video howto included."),
    "XBOX":_("Free online video converter to convert videos to the XBOX-360 format. Fast and high quality."),

    "PDF-to-Images":_("Free online pdf converter allows you to convert your pdf documents to images format."),
    "Images-to-PDF":_("Free online pdf converter allows you to convert your images to pdf document."),
    "PDF_dc":_("This PDF compression tool allows you to reduce the file size of PDFs. Optimize your documents for uploading and sending on the internet. "),
    "JPG_ic":_("JPG compression is used to reduce the file size of your images. Make images smaller with this JPG compressor. It's online and free."),
    "PNG_ic":_("PNG compression can reduce the file size of your photos, images, graphics, and other pictures. Easy-to-use and free online PNG compressor."),
    "MP4_vc":_("MP4 compression for your videos. Make your MP4 videos smaller to send or upload them. It's easy and free!"),
    "SVG_ic":_("Compress and optimize your SVG(Scalable Vector Graphics) files for free. This tool will reduce size of you svg files.")
}